// $Id: CControlPanel.cpp,v 1.5 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CControlPanel.hpp"
using Exponent::GUI::Controls::CControlPanel;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CControlPanel, CControl);

//	===========================================================================
CControlPanel::CControlPanel(IWindow *parent, IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener) 
			 : CControlRoot(parent), CControl(root, uniqueId, area, listener)
			 , m_drawPanelBounds(true)
{
	EXPONENT_CLASS_CONSTRUCTION(CControlPanel);
}

//	===========================================================================
CControlPanel::~CControlPanel()
{
	EXPONENT_CLASS_DESTRUCTION(CControlPanel);
}

//	===========================================================================
void CControlPanel::addControl(IControl *control)
{
	if (control)
	{
		control->setParentControl(this);
		CControlRoot::addControl(control);
	}
}

//	===========================================================================
void CControlPanel::lockControl(IControl *control)
{
	CControlRoot::lockControl(control);
	m_rootControl->lockControl(this);
}

//	===========================================================================
void CControlPanel::unlockControl()
{
	CControlRoot::unlockControl();
	m_rootControl->unlockControl();
}

//	===========================================================================
CPoint CControlPanel::getWindowOffset()
{
	return CPoint(m_absoluteArea.getOrigin());//m_absoluteArea.getLeft(), m_absoluteArea.getTop());
}

//	===========================================================================
void CControlPanel::drawRootControl(CGraphics &graphics)
{
	this->drawControl(graphics);
}

//	===========================================================================
void CControlPanel::handleLeftButtonDown(CMouseEvent &event)
{
	CControlRoot::handleLeftButtonDown(event);
}

//	===========================================================================
void CControlPanel::handleLeftButtonUp(CMouseEvent &event)
{
	CControlRoot::handleLeftButtonUp(event);
}

//	===========================================================================
void CControlPanel::handleRightButtonDown(CMouseEvent &event)
{
	CControlRoot::handleRightButtonDown(event);
}

//	===========================================================================
void CControlPanel::handleRightButtonUp(CMouseEvent &event)
{
	CControlRoot::handleRightButtonUp(event);
}

//	===========================================================================
void CControlPanel::handleDoubleClick(CMouseEvent &event)
{
	CControlRoot::handleDoubleClick(event);
}

//	===========================================================================
void CControlPanel::handleMouseScroll(CMouseEvent &event)
{
	CControlRoot::handleMouseScroll(event);
}

//	===========================================================================
void CControlPanel::handleMouseMovement(CMouseEvent &event)
{
	CControlRoot::handleMouseMovement(event);
}

//	===========================================================================
void CControlPanel::handleMouseLeavingArea(CMouseEvent &event)
{
	CControlRoot::handleMouseLeavingArea(event);
}

//	===========================================================================
bool CControlPanel::handleKeyDown(const CKeyboardEvent &event)
{
	return CControlRoot::handleKeyDown(event);
}

//	===========================================================================
bool CControlPanel::handleKeyUp(const CKeyboardEvent &event)
{
	return CControlRoot::handleKeyUp(event);
}

//	===========================================================================
void CControlPanel::handleFileDrop(const CDropEvent &event)
{
	CControlRoot::handleFileDrop(event);
}

//	===========================================================================
void CControlPanel::setControlRoot(IControlRoot *controlRoot)
{
	// What needs to be done here???
	CControl::setControlRoot(controlRoot);
}

//	===========================================================================
void CControlPanel::drawControl(CGraphics &graphics)
{
	// First check if we can allow the standard handler to draw the disabled control
	if (!this->drawEnabledControl(graphics))
	{
		return;
	}

	// Draw the background image, if one is assigned
	if (m_controlRootBackgroundImage)
	{
		graphics.drawImage(m_controlRootBackgroundImage, m_normalisedArea, m_controlRootBackgroundImage->getNormalisedImageSize());
	}
	else
	{
		// Draw the primary image
		this->drawPrimaryImage(graphics, m_doDefaultDrawing);
	}

	// -------------------------------------------------------------------
	// Drawing child controls
	// * We are given the clipping area as our absolute area - controls
	//   expect that when it is passed to them, the clipping area will be their area
	//   as an absolute area.
	// * The drawing offset for us is an absolute position on screen, but is offset
	//   so that we can draw from 0, 0 being our upper left hand corner
	// * The update area is the area inside and up to our own area, it is a relative position
	// * Controls are only drawn if their area intersects with the update area
	// -------------------------------------------------------------------

	// Store the clipping area
	CRect currentClippingArea;
	graphics.getClippingRegion().getCurrentClipRegion(currentClippingArea);

	// Store the original update area - this is relative to us!
	const CRect updateArea = graphics.getUpdateArea();

	// Store the drawing area offset
	const CPoint drawingOffset = graphics.getDrawingAreaOffset();

	// Now we loop through each control, updating sizes as necessary
	for (long i = 0; i < m_controlArray->getArraySize(); i++)
	{
		// Get the control
		IControl *control = (IControl *)m_controlArray->elementAtIndex(i);

		// Check its valid
		if (control)
		{
			// Get the control position relative to our top left
			const CRect controlArea = control->getArea();

			// -------------------------------------------------------------------
			// Check if its inside the update area
			// It is important to note here that there are three conceivable cases here
			// REMEMBERING THAT THE UPDATE AREA IS RELATIVE TO US!!
			// 1. Control is inside the update area (whole control should be drawn)
			// 2. Control intersects with the update area (only part of te control should be drawn)
			// 3. Control is outside the update area (control should not be drawn)
			// -------------------------------------------------------------------
			if (updateArea.rectanglesIntersect(controlArea))
			{
				// Then we know that the control is at least partially inside the update area
				// And it is either case 1 or case 2

				// If the control is entirely within the update area, then its update area is its area
				if (updateArea.rectIsInside(controlArea))
				{
					// We should draw the whole control and all the controls that it contains..
					graphics.setUpdateArea(CRect(0, 0, controlArea.getWidth(), controlArea.getHeight()));
				}
				else
				{
					// Otherwise its partially inside
					// In this case the rectangle will be the intersection area between the two controls
					CRect intersection;
					CRect::getIntersectionArea(updateArea, controlArea, intersection);
					
					// This position is still a fixed onscreen position - we want to make it relative for the control
					intersection.offset(CPoint(-controlArea.getLeft(), -controlArea.getTop()));

					// Now we can store that as the update area for this control
					graphics.setUpdateArea(intersection);
				}


				// Get the new clipping area
				CRect intersection;
				CRect::getIntersectionArea(currentClippingArea, control->getAbsoluteRect(), intersection);

#ifdef DEBUG_CLIPPING
				graphics.setDrawingAreaOffset(CPoint(0,0));
				graphics.getMutablePen()->setColour(CAlphaColour::CALPHACOLOUR_ORANGE);
				graphics.drawRectangle(intersection);
				graphics.setDrawingAreaOffset(drawingOffset);
#endif
				// Store the clipping position
				graphics.getClippingRegion().setCurrentClipRegion(intersection);

				// Now reoffset the graphics area so that controls draw from 0, 0 relative to themselves
				graphics.appendToDrawingAreaOffset(controlArea.getOrigin());

				// Draw 
				control->drawControl(graphics);

				// Now remove the offset from the graphics area so that future controls draw in the correct place....
				graphics.setDrawingAreaOffset(drawingOffset);

				// Reset the clipping region
				graphics.getClippingRegion().setCurrentClipRegion(currentClippingArea);
			}
		}
	}

	// Reset the drawing offset
	graphics.setDrawingAreaOffset(drawingOffset);

	// Reset the clipping region
	graphics.getClippingRegion().setCurrentClipRegion(currentClippingArea);

	// Store the update area
	graphics.setUpdateArea(updateArea);

	// Draw the bounds
	if (m_drawPanelBounds)
	{
		graphics.getMutablePen()->setColour(m_boundsColour);
		graphics.drawRectangle(m_normalisedArea);
	}



	/*

	// Then get an update area that reflects the area of our own control that we want to draw

	// This is stored as an absolute position onscreen - we can use this for the clipping area
	//
	//graphics.getClippingRegion().setCurrentClipRegion(*ourUpdateArea);

	



	/*
	// First check if we can allow the standard handler to draw the disabled control
	if (!this->drawEnabledControl(graphics))
	{
		return;
	}

	// ------------------------------------------------
	// Some information about drawing with the Exponent control system
	// 1. The graphics update area is the total area that will be blitted back
	//	  at the end of the drawing stage. 
	// 2. Control expect to draw based on their top left being 0, 0. Therefore
	//	  we need to offset the graphics position
	// 3. Controls expect that the clipping area is set to their actual onscreen
	//    position
	// 4. The absolute root control is the only place that you should use absolute
	//	  rectangle positions for controls. Otherwise you should always base
	//	  the position on the clipping rect, plus any other modifiers that
	//	  you wish to apply
	//
	// Notes:
	//	  In this function, we use the clipping area to represent our actual
	//	  position on screen. This is a safe assumtion to make, but one which
	//	  I may regret later ;)
	// ------------------------------------------------

	// Draw the background image, if one is assigned
	if (m_controlRootBackgroundImage)
	{
		graphics.drawImage(m_controlRootBackgroundImage, m_normalisedArea, m_controlRootBackgroundImage->getNormalisedImageSize());
	}

	// Store the update information
	const CRect update		   = graphics.getUpdateArea();
	const CPoint drawingOffset = graphics.getDrawingAreaOffset();
	CRect currentClip;
	graphics.getClippingRegion().getCurrentClipRegion(currentClip);

	// Now we loop through each control, updating sizes as necessary
	for (long i = 0; i < m_controlArray->getArraySize(); i++)
	{
		IControl *control = (IControl *)m_controlArray->elementAtIndex(i);
		if (control)
		{
			// First of all we store a relative offset position
			CRect theControlArea = currentClip;
			//theControlArea.offset(control->getArea().getOrigin());		// <<<<<<<<<<<<<  TODO : Figure out WTF this does!!

			if (currentClip.rectanglesIntersect(theControlArea))
			{
				// Then we get the intersection of the controls area and the current clipping rect
				CRect *theIntersectionArea = CRect::getIntersectionArea(currentClip, theControlArea);

				// Now we build the new clipping area
				CRect theClipArea = currentClip;
				theClipArea.offset(control->getArea().getOrigin());
				theClipArea.setWidth(theIntersectionArea->getWidth());
				theClipArea.setHeight(theIntersectionArea->getHeight());

				// Ensure that we are within the right range
				if (theClipArea.getWidth() > control->getArea().getWidth())
				{
					theClipArea.setWidth(control->getArea().getWidth());
				}

				if (theClipArea.getHeight() > control->getArea().getHeight())
				{
					theClipArea.setHeight(control->getArea().getHeight());
				}

				// Set the clipping area
				graphics.getClippingRegion().setCurrentClipRegion(theClipArea);
				
				// Clean up the pointers
				FREE_POINTER(theIntersectionArea);

				// Now reoffset the graphics area so that controls draw from 0, 0 relative to themselves
				graphics.appendToDrawingAreaOffset(control->getArea().getOrigin());

				// Draw 
				control->drawControl(graphics);

				// Now remove the offset from the graphics area so that future controls draw in the correct place....
				graphics.setDrawingAreaOffset(drawingOffset);

				// Reset the clipping region
				graphics.getClippingRegion().setCurrentClipRegion(currentClip);
			}
		}
	}

	// Reset the drawing offset
	graphics.setDrawingAreaOffset(drawingOffset);

	// Reset the clipping region
	graphics.getClippingRegion().setCurrentClipRegion(currentClip);

	// Draw the bounds
	if (m_drawPanelBounds)
	{
		graphics.getMutablePen()->setColour(m_boundsColour);
		graphics.drawRectangle(m_normalisedArea);
	}
	*/
}

//	===========================================================================
void CControlPanel::enableControl() 
{
	CControl::enableControl();
	for (long i = 0; i < m_controlArray->getArraySize(); i++)
	{
		IControl *control = (IControl *)m_controlArray->elementAtIndex(i);
		if (control)
		{
			control->enableControl();
		}
	}
}

//	===========================================================================
void CControlPanel::disableControl()
{
	CControl::disableControl();
	for (long i = 0; i < m_controlArray->getArraySize(); i++)
	{
		IControl *control = (IControl *)m_controlArray->elementAtIndex(i);
		if (control)
		{
			control->disableControl();
		}
	}
}

//	===========================================================================
bool CControlPanel::drawEnabledControl(CGraphics &graphics)
{
	if (!m_enabled)
	{
		if (m_disabledImage)
		{
			graphics.drawImage(m_disabledImage, m_normalisedArea, m_disabledImage->getNormalisedImageSize());
		}
		else
		{
			graphics.getMutableBrush()->setColour(CAlphaColour::CALPHACOLOUR_DARK_GREY);
			graphics.fillRectangle(m_normalisedArea);	
		}

		// Store the update area
		const CRect update = graphics.getUpdateArea();

		// Now we need to loop through the objects and get them to draw (they will draw disabled)
		for (long i = 0; i < m_controlArray->getArraySize(); i++)
		{
			IControl *control = (IControl *)m_controlArray->elementAtIndex(i);
			if (control && update.rectanglesIntersect(control->getAbsoluteRect()))
			{
				// Setup a new clipping region
				graphics.getClippingRegion().setCurrentClipRegion(control->getAbsoluteRect());

				// Now reoffset the graphics area so that controls draw from 0, 0 relative to themselves
				const CPoint absolute = control->getAbsoluteRect().getOrigin();
				graphics.appendToDrawingAreaOffset(absolute);

				// Draw 
				control->drawControl(graphics);

				// Now remove the offset from the graphics area so that future controls draw in the correct place....
				graphics.negateFromDrawingArea(absolute);

				// Reset the clipping region
				graphics.getClippingRegion().clearClipRegion();
			}
		}
	}
	return m_enabled;
}

//	===========================================================================
void CControlPanel::updateControl(IControl *control)
{
	//this->updateArea(control->getArea());
	m_rootControl->updateControl(control);
}

//	===========================================================================
void CControlPanel::updateArea(const CRect &area)
{
	CRect theArea = area;
	theArea.offset(m_area.getOrigin());
	m_rootControl->updateArea(theArea);
}

//	===========================================================================
void CControlPanel::getGlobalCoordinatesOfControl(IControl *control, CPoint &point)
{
	m_rootControl->getGlobalCoordinatesOfControl(control, point);
}

//	===========================================================================
void CControlPanel::getWindowCoordinatesOfControl(IControl *control, CPoint &point)
{
	// Check the control is valid
	if (control)
	{
		// First we offset to the controls position
		point.offset(control->getArea().getOrigin());

		// Then we want to know where we are!
		m_rootControl->getWindowCoordinatesOfControl(this, point);
	}
}

//	===========================================================================
void CControlPanel::setArea(const CRect &area)
{
	CControl::setArea(area);
	this->flushSizeChange();
}

//	===========================================================================
void CControlPanel::flushSizeChange()
{
	// Flush the position change
	for (long i = 0; i < this->getNumberOfControls(); i++)
	{
		// Get the control
		IControl *control = this->getControlAtIndex(i);

		// Check its actually valid
		if (control)
		{
			// By setting the area, the absolute rectangle will be flushed and recalculated...
			control->setArea(control->getArea());
		}
	}
}